/*
 * Decompiled with CFR 0.152.
 */
package ifs.docman.lotusnotes.parser;

import ifs.docman.lotusnotes.enumerations.EmailPostType;
import ifs.docman.lotusnotes.model.DocumentObjectModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.EmbeddedObject;
import lotus.domino.Item;
import lotus.domino.MIMEEntity;
import lotus.domino.Name;
import lotus.domino.NotesException;
import lotus.domino.RichTextItem;
import lotus.domino.Session;

public class DocumentParser {
    private static final String semi_colon = ";";

    public static DocumentObjectModel parseDocument(Session session, Document lotusNotesDocument, String documentStorePath) throws NotesException {
        Vector list = lotusNotesDocument.getEmbeddedObjects();
        int i = 0;
        while (i < list.size()) {
            Item item2 = (Item)list.elementAt(i);
            System.out.println("\t********* ############ @@@@@@@@@@" + item2.getName() + " = \"" + item2.getValueString() + "\"");
            ++i;
        }
        Vector items = lotusNotesDocument.getItems();
        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! BEGIN !!!!!!!!!!!!!!!!!!");
        int j = 0;
        while (j < items.size()) {
            Item item = (Item)items.elementAt(j);
            System.out.println("\t" + item.getName() + " = \"" + item.getValueString() + "\";" + item.getDateTimeValue());
            ++j;
        }
        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! END !!!!!!!!!!!!!!!!!!");
        System.out.println("*********************** getNoteID=" + lotusNotesDocument.getNoteID());
        System.out.println("*********************** getUniversalID=" + lotusNotesDocument.getUniversalID());
        System.out.println("*********************** getParentDocumentUNID=" + lotusNotesDocument.getParentDocumentUNID());
        System.out.println("*********************** getCreated=" + lotusNotesDocument.getCreated());
        System.out.println("*********************** getLastModified=" + lotusNotesDocument.getLastModified());
        DocumentObjectModel docObjMod = new DocumentObjectModel();
        docObjMod.FileNameWithoutExtension = DocumentParser.readItemFromDocument(lotusNotesDocument, "Subject").replaceAll("[\\\\/:*?\"<>|]", "");
        docObjMod.FileNameWithPath = DocumentParser.getDocumentFileNameWithPath(documentStorePath, docObjMod.FileNameWithoutExtension);
        docObjMod.FileExtension = "EML";
        docObjMod.EntryId = lotusNotesDocument.getUniversalID();
        docObjMod.StoreId = "";
        docObjMod.Subject = DocumentParser.readItemFromDocument(lotusNotesDocument, "Subject");
        docObjMod.ReceivedTime = DocumentParser.readDateItemFromDocument(lotusNotesDocument, "DeliveredDate");
        docObjMod.SentTime = DocumentParser.readDateItemFromDocument(lotusNotesDocument, "PostedDate");
        docObjMod.PostType = DocumentParser.getPostType(lotusNotesDocument);
        docObjMod.SenderName = DocumentParser.getCommonName(session, DocumentParser.readItemFromDocument(lotusNotesDocument, "From"));
        docObjMod.SenderEMail = DocumentParser.readItemFromDocument(lotusNotesDocument, "INetFrom");
        docObjMod.ToReceiverNames = DocumentParser.transformToSemicolonSeparatedString(DocumentParser.getCommonNameList(session, DocumentParser.readItemListFromDocument(lotusNotesDocument, "SendTo")));
        docObjMod.ToReceiverEmails = DocumentParser.transformToSemicolonSeparatedString(DocumentParser.readItemListFromDocument(lotusNotesDocument, "InetSendTo"));
        docObjMod.CcReceiverNames = DocumentParser.transformToSemicolonSeparatedString(DocumentParser.getCommonNameList(session, DocumentParser.readItemListFromDocument(lotusNotesDocument, "CopyTo")));
        docObjMod.CcReceiverEmails = DocumentParser.transformToSemicolonSeparatedString(DocumentParser.readItemListFromDocument(lotusNotesDocument, "InetCopyTo"));
        docObjMod.MessageBody = DocumentParser.readItemFromDocument(lotusNotesDocument, "Body");
        docObjMod.HasAttachments = DocumentParser.hasAttachments(lotusNotesDocument);
        docObjMod.IsAttachmentOnly = false;
        return docObjMod;
    }

    private static EmailPostType getPostType(Document lotusNotesDocument) throws NotesException {
        return DocumentParser.readDateItemFromDocument(lotusNotesDocument, "DeliveredDate") == null ? EmailPostType.OUT : EmailPostType.IN;
    }

    public static String getDocumentFileNameWithPath(String documentStorePath, String documentSubject) {
        return String.valueOf(documentStorePath) + documentSubject + ".eml";
    }

    public static String getCommonName(Session session, String cannonicalHierarchicalName) {
        String commonName = "";
        try {
            Name cannonicalHName = session.createName(cannonicalHierarchicalName);
            commonName = cannonicalHName.getCommon();
        }
        catch (NotesException e) {
            e.printStackTrace();
        }
        return commonName;
    }

    public static List<String> getCommonNameList(Session session, List<String> cannonicalHierarchicalNameList) {
        ArrayList<String> commonNameList = new ArrayList<String>();
        for (String cannonicalHName : cannonicalHierarchicalNameList) {
            String commonName = DocumentParser.getCommonName(session, cannonicalHName);
            commonNameList.add(commonName);
        }
        return commonNameList;
    }

    public static boolean hasAttachments(Document lotusNotesDocument) throws NotesException {
        if (lotusNotesDocument.hasEmbedded()) {
            Vector embededObjectsCollection = ((RichTextItem)lotusNotesDocument.getFirstItem("Body")).getEmbeddedObjects();
            for (EmbeddedObject embededObject : embededObjectsCollection) {
                if (1454 != embededObject.getType()) continue;
                return true;
            }
        }
        return false;
    }

    private static String getHeaderValue(MIMEEntity mimeEntity, String headerName) throws NotesException {
        Vector<String> filter = new Vector<String>();
        filter.addElement(headerName);
        return mimeEntity.getSomeHeaders(filter, true);
    }

    public static List<String> readItemListFromDocument(Document document, String itemName) throws NotesException {
        Vector values = document.getItemValue(itemName);
        return values == null ? Collections.emptyList() : values;
    }

    public static String readItemFromDocument(Document document, String itemName) throws NotesException {
        Vector values = document.getItemValue(itemName);
        if (values == null || values.size() == 0) {
            return "";
        }
        return (String)values.get(0);
    }

    public static Date readDateItemFromDocument(Document document, String itemName) throws NotesException {
        Vector values = document.getItemValue(itemName);
        if (values == null || values.size() == 0) {
            return null;
        }
        return ((DateTime)values.get(0)).toJavaDate();
    }

    private static String transformToSemicolonSeparatedString(List<String> valueList) {
        StringBuilder sb = new StringBuilder();
        for (String value : valueList) {
            if (sb.length() > 0) {
                sb.append(semi_colon);
            }
            if (value.trim() == null || value.trim().length() <= 0) continue;
            sb.append(value.trim());
        }
        return sb.toString();
    }
}

