/*
 * Decompiled with CFR 0.152.
 */
package ifs.docman.lotusnotes.model;

import ifs.docman.lotusnotes.enumerations.EmailPostType;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DocumentObjectModel {
    public static final char Char31 = '\u001f';
    public static final char Char30 = '\u001e';
    public static final String FILE_NAME_TAG = "FILE_NAME";
    public static final String ENTRY_ID_TAG = "ENTRY_ID";
    public static final String STORE_ID_TAG = "STORE_ID";
    public static final String SUBJECT_TAG = "SUBJECT";
    public static final String RECEIVED_TIME_TAG = "RECEIVED_TIME";
    public static final String RECEIVED_YEAR_TAG = "RECEIVED_YEAR";
    public static final String RECEIVED_MONTH_TAG = "RECEIVED_MONTH";
    public static final String RECEIVED_DAY_TAG = "RECEIVED_DAY";
    public static final String RECEIVED_DATE_STD_TAG = "RECEIVED_DATE_STD";
    public static final String SENT_TIME_TAG = "SENT_TIME";
    public static final String SENT_YEAR_TAG = "SENT_YEAR";
    public static final String SENT_MONTH_TAG = "SENT_MONTH";
    public static final String SENT_DAY_TAG = "SENT_DAY";
    public static final String SENT_DATE_STD_TAG = "SENT_DATE_STD";
    public static final String POST_TYPE_TAG = "POST_TYPE";
    public static final String SENDER_NAME_TAG = "SENDER_NAME";
    public static final String SENDER_EMAIL_TAG = "SENDER_EMAIL";
    public static final String TO_RECEIVER_NAMES_TAG = "TO_RECEIVER_NAMES";
    public static final String TO_RECEIVER_EMAILS_TAG = "TO_RECEIVER_EMAILS";
    public static final String CC_RECEIVER_NAMES_TAG = "CC_RECEIVER_NAMES";
    public static final String CC_RECEIVER_EMAILS_TAG = "CC_RECEIVER_EMAILS";
    public static final String MESSAGE_BODY_TAG = "MESSAGE_BODY";
    public static final String HAS_ATTACHMENTS_TAG = "HAS_ATTACHMENTS";
    public static final String ATTACHMENT_ONLY_TAG = "ATTACHMENT_ONLY";
    public String FileNameWithoutExtension;
    public String FileExtension;
    public String FileNameWithPath;
    public String EntryId;
    public String StoreId;
    public String Subject;
    public Date ReceivedTime;
    public Date SentTime;
    public EmailPostType PostType;
    public String SenderName;
    public String SenderEMail;
    public String ToReceiverNames;
    public String ToReceiverEmails;
    public String CcReceiverNames;
    public String CcReceiverEmails;
    public String MessageBody;
    public boolean HasAttachments;
    public boolean IsAttachmentOnly;
    public boolean IsDraft;

    public DocumentObjectModel clone() {
        DocumentObjectModel clonedObject = new DocumentObjectModel();
        clonedObject.FileNameWithoutExtension = this.FileNameWithoutExtension;
        clonedObject.FileNameWithPath = this.FileNameWithPath;
        clonedObject.FileExtension = this.FileExtension;
        clonedObject.EntryId = this.EntryId;
        clonedObject.StoreId = this.StoreId;
        clonedObject.Subject = this.Subject;
        clonedObject.ReceivedTime = this.ReceivedTime;
        clonedObject.SentTime = this.SentTime;
        clonedObject.PostType = this.PostType;
        clonedObject.SenderName = this.SenderName;
        clonedObject.SenderEMail = this.SenderEMail;
        clonedObject.ToReceiverNames = this.ToReceiverNames;
        clonedObject.ToReceiverEmails = this.ToReceiverEmails;
        clonedObject.CcReceiverNames = this.CcReceiverNames;
        clonedObject.CcReceiverEmails = this.CcReceiverEmails;
        clonedObject.MessageBody = this.MessageBody;
        clonedObject.HasAttachments = this.HasAttachments;
        clonedObject.IsAttachmentOnly = this.IsAttachmentOnly;
        clonedObject.IsDraft = this.IsDraft;
        return clonedObject;
    }

    public String ToString() {
        Calendar sentTimeCalendar;
        Calendar receivedTimeCalendar;
        if (this.ReceivedTime != null) {
            receivedTimeCalendar = Calendar.getInstance();
            receivedTimeCalendar.setTime(this.ReceivedTime);
        } else {
            receivedTimeCalendar = null;
        }
        if (this.SentTime != null) {
            sentTimeCalendar = Calendar.getInstance();
            sentTimeCalendar.setTime(this.SentTime);
        } else {
            sentTimeCalendar = null;
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss");
        StringBuffer sb = new StringBuffer();
        sb.append(this.generateNameValuePairString(FILE_NAME_TAG, this.FileNameWithPath));
        sb.append(this.generateNameValuePairString(ENTRY_ID_TAG, this.EntryId));
        sb.append(this.generateNameValuePairString(STORE_ID_TAG, this.StoreId));
        sb.append(this.generateNameValuePairString(SUBJECT_TAG, this.Subject));
        sb.append(this.generateNameValuePairString(RECEIVED_TIME_TAG, receivedTimeCalendar != null ? receivedTimeCalendar : null));
        sb.append(this.generateNameValuePairString(RECEIVED_YEAR_TAG, receivedTimeCalendar != null ? receivedTimeCalendar.get(1) : 0));
        sb.append(this.generateNameValuePairString(RECEIVED_MONTH_TAG, receivedTimeCalendar != null ? receivedTimeCalendar.get(2) + 1 : 0));
        sb.append(this.generateNameValuePairString(RECEIVED_DAY_TAG, receivedTimeCalendar != null ? receivedTimeCalendar.get(5) : 0));
        sb.append(this.generateNameValuePairString(RECEIVED_DATE_STD_TAG, receivedTimeCalendar != null ? dateFormatter.format(receivedTimeCalendar.getTime()) : null));
        sb.append(this.generateNameValuePairString(SENT_TIME_TAG, sentTimeCalendar != null ? sentTimeCalendar : null));
        sb.append(this.generateNameValuePairString(SENT_YEAR_TAG, sentTimeCalendar != null ? sentTimeCalendar.get(1) : 0));
        sb.append(this.generateNameValuePairString(SENT_MONTH_TAG, sentTimeCalendar != null ? sentTimeCalendar.get(2) + 1 : 0));
        sb.append(this.generateNameValuePairString(SENT_DAY_TAG, sentTimeCalendar != null ? sentTimeCalendar.get(5) : 0));
        sb.append(this.generateNameValuePairString(SENT_DATE_STD_TAG, sentTimeCalendar != null ? dateFormatter.format(sentTimeCalendar.getTime()) : null));
        sb.append(this.generateNameValuePairString(POST_TYPE_TAG, this.PostType.toString()));
        sb.append(this.generateNameValuePairString(SENDER_NAME_TAG, this.SenderName));
        sb.append(this.generateNameValuePairString(SENDER_EMAIL_TAG, this.SenderEMail));
        sb.append(this.generateNameValuePairString(TO_RECEIVER_NAMES_TAG, this.ToReceiverNames));
        sb.append(this.generateNameValuePairString(TO_RECEIVER_EMAILS_TAG, this.ToReceiverEmails));
        sb.append(this.generateNameValuePairString(CC_RECEIVER_NAMES_TAG, this.CcReceiverNames));
        sb.append(this.generateNameValuePairString(CC_RECEIVER_EMAILS_TAG, this.CcReceiverEmails));
        sb.append(this.generateNameValuePairString(MESSAGE_BODY_TAG, this.MessageBody));
        sb.append(this.generateNameValuePairString(ATTACHMENT_ONLY_TAG, this.IsAttachmentOnly));
        return sb.toString();
    }

    private String generateNameValuePairString(String name, String value) {
        return String.valueOf(name) + '\u001f' + (value == null ? "" : value) + '\u001e';
    }

    private String generateNameValuePairString(String name, boolean value) {
        return String.valueOf(name) + '\u001f' + (value ? "TRUE" : "FALSE") + '\u001e';
    }

    private String generateNameValuePairString(String name, Calendar value) {
        return String.valueOf(name) + '\u001f' + (value == null ? "" : value.getTime().toString()) + '\u001e';
    }

    private String generateNameValuePairString(String name, int value) {
        return String.valueOf(name) + '\u001f' + (value == 0 ? "" : Integer.valueOf(value)) + '\u001e';
    }
}

