/*
 * Decompiled with CFR 0.152.
 */
package ifs.docman.lotusnotes.localization;

import ifs.docman.lotusnotes.localization.TextTranslator;
import ifs.docman.lotusnotes.localization.TranslationLocator;
import ifs.docman.lotusnotes.persistance.UserSettingsManager;
import ifs.docman.lotusnotes.ui.Error;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TextTranslationCache
extends ResourceBundle {
    private static String currentLanguage = "";
    private static File currentTranslationFile;
    private static HashMap<String, String> timeStampeForLanguages;
    private static HashMap<String, String> TextsCachedFromFile;
    private static HashMap<String, String> Extensions;
    private static String[] supportedLanKeys;
    private static String[] supportedLanValues;
    private static String timeStampSupportedLanFile;

    static {
        timeStampSupportedLanFile = "";
        timeStampeForLanguages = new HashMap();
        TextsCachedFromFile = new HashMap();
        Extensions = new HashMap();
        TextTranslationCache.loadSupportedLanguages();
    }

    public static boolean changeLanguage(String languageKey) {
        currentTranslationFile = TranslationLocator.getTranslationFile(languageKey);
        if (!currentTranslationFile.exists()) {
            String errorMessage = TextTranslator.translate("TextTranslationCache.file.not.exist: Translation file for selected language does not exist");
            Error.showError(errorMessage);
            return false;
        }
        TextTranslationCache.updateTexts();
        return true;
    }

    public static int getLanguageKeyIndex(String key) {
        if (key != null) {
            int k = 0;
            while (k < supportedLanValues.length) {
                if (key.equals(supportedLanKeys[k])) {
                    return k;
                }
                ++k;
            }
        }
        return -1;
    }

    public static String getLanguageKey(String value) {
        if (value != null) {
            int k = 0;
            while (k < supportedLanValues.length) {
                if (value.equals(supportedLanValues[k])) {
                    return supportedLanKeys[k];
                }
                ++k;
            }
        }
        return "";
    }

    public static int getLanguageValueIndex(String value) {
        if (value != null) {
            int k = 0;
            while (k < supportedLanValues.length) {
                if (value.equals(supportedLanValues[k])) {
                    return k;
                }
                ++k;
            }
        }
        return 0;
    }

    public static String[] getSupportedLanKeys() {
        return supportedLanKeys;
    }

    public static String[] getsupportedLanValues() {
        return supportedLanValues;
    }

    private static void loadSupportedLanguages() {
        String timeStamp;
        File supportedLanFile = TranslationLocator.getSupportedLanguageFile();
        if (supportedLanFile != null && supportedLanFile.isFile() && !timeStampSupportedLanFile.equals(timeStamp = "" + supportedLanFile.lastModified())) {
            timeStampSupportedLanFile = timeStamp;
            try {
                try {
                    HashMap<String, String> supportedLanguages = new HashMap<String, String>();
                    FileInputStream inputStream = new FileInputStream(supportedLanFile);
                    XMLInputFactory factory = XMLInputFactory.newInstance();
                    XMLStreamReader reader = factory.createXMLStreamReader(inputStream);
                    String key = "";
                    String value = "";
                    while (reader.hasNext()) {
                        int eventType = reader.next();
                        try {
                            if (1 == eventType && "language".equals(reader.getLocalName())) {
                                key = reader.getAttributeValue("", "ifsCode");
                                key = key != null ? key : "";
                                value = reader.getElementText();
                                String string = value = value != null ? value : "";
                            }
                            if (key == null || "".equals(key)) continue;
                            supportedLanguages.put(key, value);
                        }
                        catch (Exception exception) {}
                    }
                    Object[] objectKeys = supportedLanguages.entrySet().toArray();
                    supportedLanKeys = new String[objectKeys.length];
                    supportedLanValues = new String[supportedLanKeys.length];
                    int k = 0;
                    while (k < supportedLanKeys.length) {
                        String[] tempStrArray = objectKeys[k].toString().split("=");
                        if (TranslationLocator.getTranslationFile(tempStrArray[0]).exists()) {
                            TextTranslationCache.supportedLanKeys[k] = tempStrArray[0];
                            TextTranslationCache.supportedLanValues[k] = tempStrArray[1];
                        }
                        System.out.println("(" + supportedLanKeys[k] + "," + supportedLanValues[k] + ")");
                        ++k;
                    }
                    TextTranslationCache.removeUnsuportedLanguages();
                }
                catch (XMLStreamException e) {
                    System.out.println("issue in reading timeStampSupportedLanFile: " + e);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    private static void removeUnsuportedLanguages() {
        int count = 0;
        int k = 0;
        while (k < supportedLanKeys.length) {
            if (supportedLanKeys[k] != null && !supportedLanKeys[k].equals("")) {
                ++count;
            }
            ++k;
        }
        String[] teampSupportedLanKeys = new String[count];
        String[] teampSupportedLanValues = new String[count];
        count = 0;
        int k2 = 0;
        while (k2 < supportedLanKeys.length) {
            if (supportedLanKeys[k2] != null && !"".equals(supportedLanKeys[k2])) {
                teampSupportedLanKeys[count] = supportedLanKeys[k2];
                teampSupportedLanValues[count++] = supportedLanValues[k2];
            }
            ++k2;
        }
        supportedLanKeys = teampSupportedLanKeys;
        supportedLanValues = teampSupportedLanValues;
    }

    private static void updateTexts() {
        System.out.println("TextTranslationCache#updateTexts .........");
        if (currentTranslationFile != null) {
            FileInputStream inputStream = null;
            try {
                try {
                    inputStream = new FileInputStream(currentTranslationFile);
                }
                catch (FileNotFoundException fileNotFoundException) {}
                XMLInputFactory factory = XMLInputFactory.newInstance();
                XMLStreamReader reader = factory.createXMLStreamReader(inputStream);
                String key = "";
                String value = "";
                boolean ValueGet = false;
                TextsCachedFromFile.clear();
                while (reader.hasNext()) {
                    int eventType = reader.next();
                    try {
                        if (1 == eventType) {
                            if ("Attribute".equals(reader.getLocalName())) {
                                key = reader.getAttributeValue("", "name");
                                key = key != null ? key : "";
                            } else if ("Text".equals(reader.getLocalName())) {
                                value = reader.getElementText();
                                value = value != null ? value : "";
                                ValueGet = true;
                            }
                        }
                        if (key == null || "".equals(key) || !ValueGet) continue;
                        if (key.startsWith("extensions")) {
                            Extensions.put(key, value);
                        } else {
                            TextsCachedFromFile.put(key, value);
                        }
                        ValueGet = false;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (XMLStreamException e) {
                System.out.println("issue in translation: " + e);
            }
        }
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(TextsCachedFromFile.keySet());
    }

    @Override
    protected Object handleGetObject(String arg0) {
        return TextsCachedFromFile.get(arg0);
    }

    public void init() {
        System.out.println("init         " + this);
        boolean updateTexts = false;
        currentLanguage = this.setCurrentLanguage();
        currentTranslationFile = TranslationLocator.getTranslationFile(currentLanguage);
        if (!currentTranslationFile.exists()) {
            return;
        }
        String timeStamp = "" + currentTranslationFile.lastModified();
        if (!timeStampeForLanguages.containsKey(currentLanguage)) {
            updateTexts = true;
            timeStampeForLanguages.put(currentLanguage, timeStamp);
        } else if (!timeStamp.equals(timeStampeForLanguages.get(currentLanguage))) {
            updateTexts = true;
        }
        if (updateTexts) {
            TextTranslationCache.updateTexts();
        }
    }

    private String setCurrentLanguage() {
        try {
            String currentLanguage = UserSettingsManager.read("Language");
            boolean saveCurrLngInRegitry = true;
            if (currentLanguage == null || "".equals(currentLanguage)) {
                saveCurrLngInRegitry = false;
            } else if (TextTranslationCache.getLanguageKeyIndex(currentLanguage) < 0 && ((currentLanguage = TextTranslationCache.getLanguageKey(currentLanguage)) == null || "".equals(currentLanguage))) {
                saveCurrLngInRegitry = false;
            }
            if (saveCurrLngInRegitry) {
                UserSettingsManager.write("Language", currentLanguage);
            }
            return currentLanguage;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void setCurrentLanguage(String languageKey) {
        currentLanguage = languageKey;
    }

    public static String getCurrentLanguage() {
        return currentLanguage;
    }
}

