/*
 * Decompiled with CFR 0.152.
 */
package ifs.docman.lotusnotes.io;

import ifs.docman.lotusnotes.io.DirectoryManager;
import ifs.docman.lotusnotes.model.DocumentObjectModel;
import ifs.docman.lotusnotes.parser.DocumentParser;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import lotus.domino.Document;
import lotus.domino.EmbeddedObject;
import lotus.domino.MIMEEntity;
import lotus.domino.NotesException;
import lotus.domino.RichTextItem;
import lotus.domino.Session;

public class DocumentWriter {
    private static final String DEFAULT_DOCUMENT_PATH = "Office Add-In temp files";
    private static final String DEFAULT_METADATA_PATH = "Correspondence temp files";
    private static final String INDEX_FILE_NAME = "Check In File List.txt";
    private static final String FILENAME_TAG = "FILE_NAME";
    private static String metaDataFileStorePath;
    private static String documentStorePath;

    public static void WriteDocument(Session session, Document lotusNotesDocument, String randomFolder, boolean saveAttachmentsOnly) throws NotesException, IOException {
        String longerPath;
        lotusNotesDocument.removeItem("$KeepPrivate");
        DocumentObjectModel docObjModel = DocumentParser.parseDocument(session, lotusNotesDocument, documentStorePath);
        String string = longerPath = metaDataFileStorePath.length() > documentStorePath.length() ? metaDataFileStorePath : documentStorePath;
        if (saveAttachmentsOnly && docObjModel.HasAttachments) {
            ArrayList<String> fileNameList = new ArrayList<String>();
            Vector embededObjectsCollection = ((RichTextItem)lotusNotesDocument.getFirstItem("Body")).getEmbeddedObjects();
            for (EmbeddedObject embededObject : embededObjectsCollection) {
                if (1454 != embededObject.getType()) continue;
                embededObject.getSource();
                String attachmentNameWithOutExtension = embededObject.getSource().split("\\.(?=[^\\.]+$)")[0];
                String attachmentExtension = embededObject.getSource().split("\\.(?=[^\\.]+$)")[1];
                if ("txt".length() > attachmentExtension.length()) {
                    // empty if block
                }
                String shortenedAttachmentNameWithOutExtension = DocumentWriter.getShortenedFileName(longerPath, attachmentNameWithOutExtension, attachmentExtension);
                String attachmentFilePath = String.valueOf(documentStorePath) + shortenedAttachmentNameWithOutExtension + "." + attachmentExtension;
                fileNameList.add(attachmentFilePath);
                embededObject.extractFile(attachmentFilePath);
                DocumentObjectModel attachmentObjectModel = docObjModel.clone();
                attachmentObjectModel.FileNameWithPath = String.valueOf(documentStorePath) + attachmentNameWithOutExtension + "." + attachmentExtension;
                attachmentObjectModel.FileExtension = attachmentExtension;
                attachmentObjectModel.IsAttachmentOnly = true;
                String metaDataFilePath = String.valueOf(metaDataFileStorePath) + shortenedAttachmentNameWithOutExtension + ".txt";
                DocumentWriter.WriteMetadataFile(attachmentObjectModel, metaDataFilePath, metaDataFileStorePath);
            }
            DocumentWriter.WriteFileList(fileNameList, metaDataFileStorePath);
        } else {
            lotusNotesDocument.convertToMIME(2, 0);
            String longerExtension = "txt".length() > docObjModel.FileExtension.length() ? "txt" : docObjModel.FileExtension;
            docObjModel.FileNameWithoutExtension = DocumentWriter.getShortenedFileName(longerPath, docObjModel.FileNameWithoutExtension, longerExtension);
            String metaDataFilePath = String.valueOf(metaDataFileStorePath) + docObjModel.FileNameWithoutExtension + ".txt";
            ArrayList<String> fileNameList = new ArrayList<String>();
            fileNameList.add(String.valueOf(documentStorePath) + docObjModel.FileNameWithoutExtension + "." + docObjModel.FileExtension);
            DocumentWriter.WriteFileList(fileNameList, metaDataFileStorePath);
            DocumentWriter.WriteMetadataFile(docObjModel, metaDataFilePath, metaDataFileStorePath);
            DocumentWriter.WriteDocumentToDisk(lotusNotesDocument, docObjModel, documentStorePath);
        }
    }

    private static String getShortenedFileName(String path, String fileNameWithoutExt, String extension) {
        int MAX_LENGTH = 250;
        String originalString = String.valueOf(path) + fileNameWithoutExt + "." + extension;
        int necessaryPartLength = (String.valueOf(path) + "." + extension).length() + 3;
        if (originalString.length() > MAX_LENGTH) {
            return String.valueOf(fileNameWithoutExt.substring(0, MAX_LENGTH - necessaryPartLength)) + "...";
        }
        return fileNameWithoutExt;
    }

    private static void WriteFileList(List<String> fileNameList, String metaDataFileStorePath) throws IOException {
        String indexFilePath = String.valueOf(metaDataFileStorePath) + INDEX_FILE_NAME;
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(indexFilePath, true), "UTF8"));
        for (String fileName : fileNameList) {
            out.append("FILE_NAME\u001f" + fileName + '\u001e' + System.getProperty("line.separator"));
        }
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    private static void WriteMetadataFile(DocumentObjectModel docObjModel, String metaDataFilePath, String metaDataFileStorePath) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(metaDataFilePath), "UTF8"));
        out.append(docObjModel.ToString());
        ((Writer)out).close();
    }

    private static void WriteDocumentToDisk(Document lotusNotesDocument, DocumentObjectModel docObjModel, String documentStorePath) throws NotesException, IOException {
        MIMEEntity mE = null;
        MIMEEntity mChild = null;
        String contenttype = null;
        String headers = null;
        String content = null;
        FileWriter output = null;
        lotusNotesDocument.getNoteID();
        mE = lotusNotesDocument.getMIMEEntity("Body");
        output = new FileWriter(String.valueOf(documentStorePath) + docObjModel.FileNameWithoutExtension + "." + docObjModel.FileExtension);
        try {
            contenttype = mE.getContentType();
            headers = mE.getHeaders();
            int encoding = mE.getEncoding();
            int index = headers.indexOf("MIME-Version:");
            if (index < 0) {
                output.write("MIME-Version: 1.0\n");
            }
            output.write(headers);
            content = mE.getContentAsText();
            if (content != null && content.trim().length() > 0) {
                output.write(content);
                output.write("\n");
            }
            if (contenttype.startsWith("multipart")) {
                mE.getPreamble();
                mChild = mE.getFirstChildEntity();
                while (mChild != null) {
                    headers = mChild.getHeaders();
                    encoding = mChild.getEncoding();
                    if (encoding == 1730) {
                        mChild.encodeContent(1727);
                        headers = mChild.getHeaders();
                    }
                    mChild.getPreamble();
                    content = mChild.getBoundaryStart();
                    output.write(content);
                    if (!content.endsWith("\n")) {
                        output.write("\n");
                    }
                    output.write(headers);
                    output.write("\n");
                    content = mChild.getContentAsText();
                    if (content != null && content.length() > 0) {
                        output.write(content);
                    }
                    output.write(mChild.getBoundaryEnd());
                    mChild = mChild.getNextSibling();
                }
            }
            output.write(mE.getBoundaryEnd());
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    private static void parseMultiPartElement(MIMEEntity currentEntitiy, Writer output) throws NotesException, IOException {
        while (currentEntitiy != null) {
            String content;
            String boundaryStart;
            String headers = currentEntitiy.getHeaders();
            int encoding = currentEntitiy.getEncoding();
            if (encoding == 1730) {
                currentEntitiy.encodeContent(1727);
                headers = currentEntitiy.getHeaders();
            }
            if (!(boundaryStart = currentEntitiy.getBoundaryStart()).endsWith("\n")) {
                boundaryStart = String.valueOf(boundaryStart) + "\n";
            }
            output.write(boundaryStart);
            output.write(headers);
            output.write("\n");
            MIMEEntity childEntity = currentEntitiy.getFirstChildEntity();
            if (childEntity != null) {
                DocumentWriter.parseMultiPartElement(childEntity, output);
            }
            if ((content = currentEntitiy.getContentAsText()) != null && content.length() > 0) {
                output.write(content);
            }
            output.write(currentEntitiy.getBoundaryEnd());
            currentEntitiy = currentEntitiy.getNextSibling();
        }
    }

    public static void createFolders(String randomPath) {
        metaDataFileStorePath = DirectoryManager.generateFolder(randomPath, DEFAULT_METADATA_PATH);
        documentStorePath = DirectoryManager.generateFolder(randomPath, DEFAULT_DOCUMENT_PATH);
    }
}

